<?php
session_start();
include 'conexao.php';

// Coleta e limpa os dados do formulário
$turma_id = trim($_POST['turma_id'] ?? '');
$nome = trim($_POST['nome'] ?? '');
$senha = trim($_POST['senha'] ?? '');

// Verificação de campos obrigatórios
if (empty($turma_id) || empty($nome) || empty($senha)) {
    $_SESSION['erro_login_aluno'] = "Preencha todos os campos.";
    header("Location: login_aluno.php");
    exit;
}

// Buscar o aluno específico
$stmt = $conn->prepare("SELECT * FROM alunos WHERE turma_id = ? AND nome = ?");
$stmt->bind_param("is", $turma_id, $nome);
$stmt->execute();
$result = $stmt->get_result();

if ($aluno = $result->fetch_assoc()) {
 if ($senha === $aluno['senha']) {


        // Buscar o nome da turma
        $stmt_turma = $conn->prepare("SELECT nome FROM turmas WHERE id = ?");
        $stmt_turma->bind_param("i", $aluno['turma_id']);
        $stmt_turma->execute();
        $res_turma = $stmt_turma->get_result();
        $turma = $res_turma->fetch_assoc();

        // Cria sessão com os dados completos do aluno
        $_SESSION['aluno'] = [
            'id' => $aluno['id'],
            'nome' => $aluno['nome'],
            'turma_id' => $aluno['turma_id'],
            'turma_nome' => $turma['nome'] ?? 'Turma Desconhecida',
            'curso' => $aluno['curso'],
            'classe' => $aluno['classe'],
            'numero_ordem' => $aluno['numero_ordem'],
            'foto' => !empty($aluno['foto']) ? $aluno['foto'] : 'sem-foto.png'
        ];

        header("Location: painel_aluno.php");
        exit;

    } else {
        // Senha incorreta
        $_SESSION['erro_login_aluno'] = "Senha incorreta.";
        header("Location: login_aluno.php");
        exit;
    }
} else {
    // Aluno não encontrado
    $_SESSION['erro_login_aluno'] = "Aluno não encontrado na turma.";
    header("Location: login_aluno.php");
    exit;
}
